#ifndef __C4DBASESELECT_H
#define __C4DBASESELECT_H

#include "operatingsystem.h"
#include "c4d_file.h"

class BaseSelect
{
	private:
		BaseSelect(void);
	public:
		void FlushAll(void);

		LONG GetCount(void);
		LONG GetSegments(void);

		Bool Select(LONG num);           
		Bool SelectAll(LONG min, LONG max);

		Bool Deselect(LONG num);
		Bool DeselectAll(void);

		Bool Toggle(LONG num);
		Bool ToggleAll(LONG min, LONG max);

		Bool GetRange(LONG seg, LONG *a, LONG *b);
		
		Bool IsSelected(LONG num) { return C4DOS.Bs->IsSelected(this,num); }

		Bool CopyTo(BaseSelect *dest);
		BaseSelect *GetClone(void);

		Bool FromArray(UCHAR *selection, LONG count);
		UCHAR *ToArray(LONG count);

		void Write(HyperFile *hf);
		Bool Read(HyperFile *hf);

		static BaseSelect *Alloc(void);
		static void Free(BaseSelect *&bs);
};

#endif
